/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.app;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.StandardDrawingView;
import DE.siemens.ad.kop.app.KopEditorInfo;
import DE.siemens.ad.kop.app.KopMenuManager;
import DE.siemens.ad.kop.app.LayoutProducerKop;
import DE.siemens.ad.kop.app.LogoDrawingKOP;
import DE.siemens.ad.kop.app.LogoDrawingViewKOP;
import DE.siemens.ad.kop.model.KopProgrammingLanguage;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerException;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.RolloverButtonToolBar;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.pdraw.action.BlockToolAction;
import DE.siemens.ad.pdraw.action.SimulationToolAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.ImageBlockTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.TreeImageBlockTool;
import DE.siemens.ad.pdraw.util.GridInfo;
import DE.siemens.ad.pdraw.util.LineGridPainter;
import DE.siemens.ad.pdraw.util.PageLinePainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.help.CSH;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.JTree;

public class LogoComfortKOP
extends LogoComfort {
    protected StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        LogoDrawingViewKOP view = new LogoDrawingViewKOP(this, d.width, d.height);
        CSH.setHelpIDString((Component)view, (String)"window.DrawingView");
        GridInfo gridInfo = new GridInfo(view);
        view.setGridInfo(gridInfo);
        view.setAutoscrolls(false);
        view.addBackground(new PageLinePainter());
        view.addBackground(new LineGridPainter(view.getGridInfo()));
        return view;
    }

    protected BlockToolAction[] createBlockToolActions() {
        BlockToolAction[] blockToolActions = null;
        BlockGroup rootBlockGroup = null;
        if (this.fHardware == null) {
            blockToolActions = new BlockToolAction[]{};
            return blockToolActions;
        }
        rootBlockGroup = KopProgrammingLanguage.getInstance().getAvailableBlockGroups(this.fHardware);
        blockToolActions = new BlockToolAction[rootBlockGroup.getElementCount()];
        for (int i = 0; i < rootBlockGroup.getElementCount(); ++i) {
            BlockGroup blockGroup = (BlockGroup)rootBlockGroup.getElementAt(i);
            ImageBlockTool tool = new ImageBlockTool(blockGroup);
            BlockToolAction bta = (BlockToolAction)this.getActionManager().getActionFactory().getAction("BlockToolAction", "BlockToolAction" + i);
            bta.setIcon(blockGroup.getName() + "Icon");
            bta.setTextKey("block." + blockGroup.getName());
            bta.setDefaultText(blockGroup.getName());
            bta.setTool(tool);
            blockToolActions[i] = bta;
        }
        this.fTreeImageBlockTool = new TreeImageBlockTool(rootBlockGroup);
        JTree blockTree = this.fTreeImageBlockTool.getBlockTree();
        blockTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (LogoComfortKOP.this.fTool != LogoComfortKOP.this.fTreeImageBlockTool) {
                    LogoComfortKOP.this.setTool(LogoComfortKOP.this.fTreeImageBlockTool, Language.getString("tool.catalog", "Catalog"), new SimulationToolAction());
                }
            }
        });
        return blockToolActions;
    }

    public EditorInfo getEditorInfo() {
        return new KopEditorInfo();
    }

    public void init(Application application) {
        this.open();
        this.fApplication = application;
        this.getMenuManager().getMenuBar(application.getMenuActionGroup());
        this.fStandardToolBar = this.getMenuManager().getToolBar(application.getToolbarActionGroup());
    }

    public MenuManager getMenuManager() {
        if (this.fMenuManager == null || !(this.fMenuManager instanceof KopMenuManager)) {
            this.fMenuManager = new KopMenuManager(this);
        }
        return this.fMenuManager;
    }

    public boolean upload(ProgressListener progressListener) {
        WiringDiagram wiringDiagramFup = this.uploadWiringDiagram(progressListener);
        if (wiringDiagramFup == null) {
            return false;
        }
        CompilerFupToKop compilerFupToKop = new CompilerFupToKop();
        WiringDiagramKop wiringDiagramKop = null;
        try {
            wiringDiagramKop = compilerFupToKop.compile(wiringDiagramFup);
        }
        catch (CompilerException e) {
            JOptionPane.showMessageDialog(this.getApplicationSurface(), e.getMessage(), Language.getString("file.convertToKop", "Convert to LAD"), 0);
            return false;
        }
        this.setWiringDiagram(wiringDiagramKop);
        LayoutProducerKop layoutProducer = new LayoutProducerKop((LogoDrawingView)this.getView(), wiringDiagramKop.getBlocks());
        layoutProducer.layout();
        return true;
    }

    protected Drawing createDrawing() {
        LogoDrawingKOP logoDrawingKOP = new LogoDrawingKOP();
        this.setHardware(logoDrawingKOP.getWiringDiagram().getHardware());
        return logoDrawingKOP;
    }

    public boolean checkDrawing() {
        if (!((WiringDiagramKop)((LogoDrawing)this.drawing()).getWiringDiagram()).getNotConnectedContacts().isEmpty()) {
            String message = Language.getString("msg.unconnectedContacts", "The wiring diagram contains unconnected Contacts.\nDo you wish to connect them with the power rail?");
            int rw = JOptionPane.showConfirmDialog(this.getWindow(), message, Language.getString("edit.connectContactsWithPowerRail", "Connect contacts with power rail"), 0, 3);
            if (rw == 2) {
                return false;
            }
            if (rw == 0) {
                LogoAction connectAction = this.getActionFactory().getAction("DE.siemens.ad.kop.app.ConnectWithPowerRailAction");
                this.getActionManager().invokeAction(connectAction);
            }
        }
        return true;
    }

    public void download() {
        this.checkDrawing();
        super.download();
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
            this.initializeActionFactory(this.fActionFactory);
        }
        return this.fActionFactory;
    }

    public void displayInfoWiringDiagram() {
        this.displayUsedRessources();
        Log.println("");
        this.displaySuitableHardware();
        WiringDiagram wd = ((LogoDrawing)this.drawing()).getWiringDiagram().getFup();
        Hashtable errors = wd.getErrors();
        Hashtable warnings = wd.getWarnings();
        if (!((Dictionary)errors).isEmpty() || !((Dictionary)warnings).isEmpty()) {
            Log.println("");
            Log.println(Language.getString("editor.documentName.fupEditor", "FBD") + ":");
        }
        this.displayDict(errors);
        this.displayDict(warnings);
    }

    protected boolean readFromImport(String file, ProgressListener progressListener) throws IOException {
        super.readFromImport(file, progressListener);
        LogoDrawing fupDrawing = (LogoDrawing)this.drawing();
        WiringDiagram wiringDiagramFup = fupDrawing.getWiringDiagram();
        CompilerFupToKop compilerFupToKop = new CompilerFupToKop();
        WiringDiagramKop wiringDiagramKop = null;
        try {
            wiringDiagramKop = compilerFupToKop.compile(wiringDiagramFup);
        }
        catch (CompilerException compilerException) {
            JOptionPane.showMessageDialog(this.getWindow(), compilerException.getMessage(), "Error", 0);
            return false;
        }
        this.initDrawing();
        this.setWiringDiagram(wiringDiagramKop);
        LayoutProducerKop layoutProducer = new LayoutProducerKop(this.view(), wiringDiagramKop.getBlocks());
        layoutProducer.layout();
        LogoDrawing kopDrawing = (LogoDrawing)this.drawing();
        compilerFupToKop.transferComments(kopDrawing, fupDrawing);
        return true;
    }

    protected void initializeActionFactory(ActionFactory actionFactory) {
        actionFactory.getAction("DE.siemens.ad.kop.app.KopDeleteFiguresAction", "DeleteFiguresAction");
        actionFactory.getAction("DE.siemens.ad.kop.app.KopSimulationToolAction", "SimulationToolAction");
        actionFactory.getAction("DE.siemens.ad.kop.app.KopOnlineTestToolAction", "OnlineTestToolAction");
        actionFactory.getAction("DE.siemens.ad.kop.app.KopPasteAction", "PasteAction");
        actionFactory.getAction("DE.siemens.ad.kop.app.KopInsertBlockAction", "InsertBlockAction");
    }

    public View loadDocument(File file, ProgressListener progressListener) {
        View view = super.loadDocument(file, progressListener);
        if (view != null && ((LogoDrawing)this.drawing()).getWiringDiagram() != null) {
            WiringDiagramKop kop = (WiringDiagramKop)((LogoDrawing)this.drawing()).getWiringDiagram();
            kop.registerContactsAsBlockNameChangedListener();
        }
        return view;
    }

    protected void addTools(JToolBar palette) {
        ActionFactory actionFactory = this.getActionManager().getActionFactory();
        RolloverButtonToolBar toolbar = (RolloverButtonToolBar)palette;
        toolbar.add((LogoToggleAction)actionFactory.getAction("SelectionToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("ConnectedTextToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("CutConnectToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("ConnectionToolAction"));
        BlockToolAction[] blockToolActions = this.getBlockToolActions();
        for (int i = 0; i < blockToolActions.length; ++i) {
            toolbar.add(blockToolActions[i]);
        }
        toolbar.add((LogoToggleAction)actionFactory.getAction("SimulationToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("OnlineTestToolAction"));
    }

    protected void setOnlineTestActivated(Hardware newHardware) {
        this.getActionFactory().getAction("OnlineTestToolAction").setActivated(newHardware.supports("onlineTest"));
    }
}

